/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PrivateCrafting;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractCraftingRequestResolver;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrivateWorkerCraftingRequestResolver
extends AbstractCraftingRequestResolver {
    public PrivateWorkerCraftingRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token, false);
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> completedRequest) {
        return null;
    }

    @Override
    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    @NotNull
    public IFormattableTextComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        if (!request.hasParent()) {
            return new TranslationTextComponent("com.minecolonies.coremod.resolvers.crafter.private");
        }
        request = manager.getRequestForToken((IToken<?>)request.getParent());
        if (request == null) {
            return new TranslationTextComponent("com.minecolonies.coremod.resolvers.crafter.private");
        }
        return request.getRequester().getRequesterDisplayName(manager, request).func_230529_a_((ITextComponent)new StringTextComponent(" (")).func_230529_a_((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.resolvers.crafter.private")).func_230529_a_((ITextComponent)new StringTextComponent(")"));
    }

    @Override
    public int getPriority() {
        return 125;
    }

    @Override
    public boolean canBuildingCraftStack(@NotNull AbstractBuildingWorker building, Predicate<ItemStack> stackPredicate) {
        for (ICraftingBuildingModule module : building.getModules(ICraftingBuildingModule.class)) {
            IRecipeStorage recipe = module.getFirstRecipe(stackPredicate);
            if (recipe == null || recipe.getIntermediate() != null && recipe.getIntermediate() != Blocks.field_150350_a) continue;
            return true;
        }
        return false;
    }

    @Override
    protected IRequestable createNewRequestableForStack(ItemStack stack, int count, int minCount, IToken<?> recipeStorage) {
        return new PrivateCrafting(stack, count, minCount, recipeStorage);
    }
}

